package com.bycom.versapro.Utils;


import static com.bycom.versapro.Serializables.Constant.gson;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;

import com.bycom.versapro.Serializables.AppConfig;
import com.bycom.versapro.MenuTypes.WordPress.Adapters.WPPostAdapter;

import com.google.gson.reflect.TypeToken;
import com.wordpress.restapi.Serializables.WPCategory;
import com.wordpress.restapi.Serializables.WPPost;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PrefUtil {



    public static SharedPreferences appPreference;
    public static SharedPreferences.Editor appEditor;
    private static SharedPreferences bookmarkPreferences;
    private static SharedPreferences.Editor bookmarkEditor;
    private static SharedPreferences categoriesPreference;
    private static SharedPreferences.Editor categoriesEditor;

    public static class Preference implements Serializable {

        public static String AppPreference = "AppPref";
        public static String WordPressBookmarks = "WPBookmarkPref";
        public static String WordPressCategories = "WPCategoriesPref";
        public static String NightMode = "NightMode";
        public static String AppInfoJson = "AppInfoJson";

        public static String isIntro = "IsIntro";


    }

    public static void initializeSharedPref(Context context){

        appPreference = context.getSharedPreferences(Preference.AppPreference, Context.MODE_PRIVATE);
        appEditor = appPreference.edit();

        bookmarkPreferences = context.getSharedPreferences(Preference.WordPressBookmarks,Context.MODE_PRIVATE);
        bookmarkEditor = bookmarkPreferences.edit();

        categoriesPreference = context.getSharedPreferences(Preference.WordPressCategories,Context.MODE_PRIVATE);
        categoriesEditor = categoriesPreference.edit();
    }

    public static Boolean isIntroCompleted() {
        return appPreference.getBoolean(Preference.isIntro,false);
    }

    public static void setIntroCompleted(Boolean b){
        appEditor.putBoolean(Preference.isIntro,b);
        appEditor.apply();
    }

    public static Boolean isNight(){
        return appPreference.getBoolean(Preference.NightMode,true);
    }

    public static void setNight(Boolean is_night){
        appEditor.putBoolean(Preference.NightMode,is_night);
        appEditor.apply();
    }

    public static AppConfig getAppConfig(){
        String json = appPreference.getString(Preference.AppInfoJson,"");
        return gson.fromJson(json, AppConfig.class);
    }

    public static void updateAppInfo(AppConfig appConfig){
        appEditor.putString(Preference.AppInfoJson,gson.toJson(appConfig));
        appEditor.apply();
    }


    public static void addCategories(String BASE_URL, HashMap<Integer, WPCategory> categoryHashMap) {
        for (Map.Entry<Integer, WPCategory> entry : categoryHashMap.entrySet()) {
            int categoryId = entry.getKey();
            WPCategory category = entry.getValue();
            categoriesEditor.putString("category:" + BASE_URL + ":" + categoryId, gson.toJson(category));
        }
        categoriesEditor.apply();
    }

    public static HashMap<Integer, WPCategory> getAllCategories(String BASE_URL) {
        HashMap<Integer, WPCategory> categoryHashMap = new HashMap<>();
        Map<String, ?> allEntries = categoriesPreference.getAll();

        for (Map.Entry<String, ?> entry : allEntries.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("category:" + BASE_URL + ":")) {
                int categoryId = Integer.parseInt(key.substring(("category:" + BASE_URL + ":").length()));
                String json = (String) entry.getValue();
                WPCategory category = gson.fromJson(json, WPCategory.class);
                categoryHashMap.put(categoryId, category);
            }
        }

        return categoryHashMap;
    }

    public static WPCategory getCategory(String BASE_URL, int categoryId) {

        String json = categoriesPreference.getString("category:" + BASE_URL + ":" + categoryId, "");
        if (!json.isEmpty()) {
            return gson.fromJson(json, WPCategory.class);
        }
        return null;
    }


    public static int getTextZoom(){
        return appPreference.getInt("TextZoom",100);
    }

    public static void setTextZoom(int value){
        appEditor.putInt("TextZoom",value);
        appEditor.apply();
    }



    public static void addBookmark(WPPost post) {
        Type type = new TypeToken<WPPost>() {}.getType();
        WPPost post1 = gson.fromJson(gson.toJson(post), type);
        post1.setType(WPPostAdapter.ITEM_POST);

        bookmarkEditor.putString(post1.getLink(), gson.toJson(post1));
        bookmarkEditor.apply();
    }

    public static void removeBookmark(WPPost post) {
        bookmarkEditor.remove(post.getLink());
        bookmarkEditor.apply();
    }

    public static boolean isBookmarked(WPPost post) {
        return bookmarkPreferences.contains(post.getLink());
    }

    public static ArrayList<WPPost> getBookmarkedPosts() {
        ArrayList<WPPost> bookmarkedPosts = new ArrayList<>();
        Map<String, ?> allEntries = bookmarkPreferences.getAll();
        Type type = new TypeToken<WPPost>() {}.getType();

        for (Map.Entry<String, ?> entry : allEntries.entrySet()) {
            String json = entry.getValue().toString();
            WPPost post = gson.fromJson(json, type);
            bookmarkedPosts.add(post);
        }

        return bookmarkedPosts;
    }



}
